import { ApolloClient } from 'apollo-client';
import { HttpLink } from 'apollo-link-http';
import { concat } from 'apollo-link';
import { onError } from 'apollo-link-error'
import { InMemoryCache } from 'apollo-cache-inmemory';
import {AuthService} from '../services';
import { ApolloLinkWithoutTypename } from './ApolloLinkWithoutTypename'

const logoutLink = onError(data => {
    if(data.graphQLErrors.message === "AuthenticationError") {
        AuthService.logout();
    }
});

const createAuthMiddleware = (store) => {
    return new ApolloLinkWithoutTypename((operation, forward) => {

        const {auth} = store.getState()
        const {token} = auth;

        operation.setContext({
            headers: {
                Authorization: token || null,
            }
        })

        return forward(operation)
    })
}


export const createClient = (store) => {
    return new ApolloClient({
        link: logoutLink.concat(concat(
            new ApolloLinkWithoutTypename(),
            //createAuthMiddleware(store),
            new HttpLink({
                //uri: 'http://localhost:8180/LifeEremitaWeb/graphql',
		uri: '/LifeEremitaWeb/graphql',
                credentials: 'same-origin',
            }),
        )),
        cache: new InMemoryCache()
    });
};
